package com.ejie.ab04b.util;

import java.util.Date;

import com.ejie.aa66.ObjectFactory;
import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.ConstantesServicioCorrespondencia;
import com.ejie.ab04b.constantes.SituacionEntregaEnum;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.DatosEnvioPostal;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.DocumentoAperturas;
import com.ejie.ab04b.model.DocumentoOS2;
import com.ejie.ab04b.model.DocumentoOS3;
import com.ejie.ab04b.model.OS2;
import com.ejie.ab04b.model.OS3;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.ab04b.webservice.client.aa66.DestinatarioWs;
import com.ejie.ab04b.webservice.client.aa66.EnvioOutWs;
import com.ejie.ab04b.webservice.client.aa66.EnvioWs;
import com.ejie.ab04b.webservice.client.aa66.IdentTramitadorCondicionalWs;
import com.ejie.ab04b.webservice.client.aa66.IdentTramitadorWs;
import com.ejie.ab04b.webservice.client.aa66.RemesaOutWs;
import com.ejie.ab04b.webservice.client.aa66.RemesaWs;

/**
 * 
 * @author GFI-NORTE
 * 
 */
public final class ServicioCorrespondenciaUtils {

	private static ServicioCorrespondenciaUtils instance;

	/**
	 * Constructor privado ya que ha de utilizarse el método getInstance().
	 */
	private ServicioCorrespondenciaUtils() {

	}

	/**
	 * Devuelve la instancia de tipo GatUtils.
	 * 
	 *  Devuelve la instancia de tipo GatUtils
	 *
	 * @return single instance of ServicioCorrespondenciaUtils
	 */
	public static final ServicioCorrespondenciaUtils getInstance() {
		if (ServicioCorrespondenciaUtils.instance == null) {
			ServicioCorrespondenciaUtils.instance = new ServicioCorrespondenciaUtils();
		}
		return ServicioCorrespondenciaUtils.instance;
	}

	/**
	 * Crea un objeto RemesaWs a partir de sus atributos.
	 * 
	 *  documento
	 *            List<TramiteExpediente>
	 *  usuario
	 *            the usuario
	 *  RemesaWs
	 *
	 * @param documento the documento
	 * @param usuario the usuario
	 * @return the remesa ws
	 */
	public RemesaWs construirRemesaWs(DocumentoAperturas documento,
			String usuario) {

		RemesaWs remesa = new RemesaWs();

		remesa.setAplicacion(Constantes.APLICACION);
		remesa.setUidPuestoTramitador(UtilSeguridad.getInstance()
				.getUserCredentials() != null ? UtilSeguridad.getInstance()
				.getUserCredentials().getPosition() : usuario);

		remesa.setDescripcionRemesa(PropertiesUtil
				.getProperty(PropertiesUtil.ENVIO_POSTAL_REMESA_DESCRIPCION));
		remesa.setRecibirMail(false);

		remesa.setTelefonoTramitador(PropertiesUtil
				.getProperty(PropertiesUtil.ENVIO_POSTAL_TELEFONO_DELEGACION
						.concat(documento.getTramiteAperturas().getApertura()
								.getTerape056())));

		remesa.setTipoRemesa(ConstantesServicioCorrespondencia.TIPO_REMESA_DIARIA);

		remesa.getListaEnvios().add(this.construirEnvioWs(documento, usuario));

		return remesa;

	}

	/**
	 * Crea un objeto RemesaWs a partir de sus atributos.
	 * 
	 *  documento
	 *            List<TramiteExpediente>
	 *  usuario
	 *            the usuario
	 *  RemesaWs
	 *
	 * @param documento the documento
	 * @param usuario the usuario
	 * @return the remesa ws
	 */
	public RemesaWs construirRemesaWs(DocumentoOS2 documento, String usuario) {

		RemesaWs remesa = new RemesaWs();

		remesa.setAplicacion(Constantes.APLICACION);
		remesa.setUidPuestoTramitador(UtilSeguridad.getInstance()
				.getUserCredentials() != null ? UtilSeguridad.getInstance()
				.getUserCredentials().getPosition() : usuario);

		remesa.setDescripcionRemesa(PropertiesUtil
				.getProperty(PropertiesUtil.ENVIO_POSTAL_REMESA_DESCRIPCION));
		remesa.setRecibirMail(false);

		remesa.setTelefonoTramitador(PropertiesUtil
				.getProperty(PropertiesUtil.ENVIO_POSTAL_TELEFONO_DELEGACION
						.concat(documento.getTramiteOS2().getos2()
								.getTeros2060())));

		remesa.setTipoRemesa(ConstantesServicioCorrespondencia.TIPO_REMESA_DIARIA);

		remesa.getListaEnvios().add(this.construirEnvioWs(documento, usuario));

		return remesa;

	}

	/**
	 * Crea un objeto RemesaWs a partir de sus atributos.
	 * 
	 *  documento
	 *            List<TramiteExpediente>
	 *  usuario
	 *            the usuario
	 *  RemesaWs
	 *
	 * @param documento the documento
	 * @param usuario the usuario
	 * @return the remesa ws
	 */
	public RemesaWs construirRemesaWs(DocumentoOS3 documento, String usuario) {

		RemesaWs remesa = new RemesaWs();

		remesa.setAplicacion(Constantes.APLICACION);
		remesa.setUidPuestoTramitador(UtilSeguridad.getInstance()
				.getUserCredentials() != null ? UtilSeguridad.getInstance()
				.getUserCredentials().getPosition() : usuario);

		remesa.setDescripcionRemesa(PropertiesUtil
				.getProperty(PropertiesUtil.ENVIO_POSTAL_REMESA_DESCRIPCION));
		remesa.setRecibirMail(false);

		remesa.setTelefonoTramitador(PropertiesUtil
				.getProperty(PropertiesUtil.ENVIO_POSTAL_TELEFONO_DELEGACION
						.concat(documento.getTramiteOS3().getOs3()
								.getTeros3061())));

		remesa.setTipoRemesa(ConstantesServicioCorrespondencia.TIPO_REMESA_DIARIA);

		remesa.getListaEnvios().add(this.construirEnvioWs(documento, usuario));

		return remesa;

	}

	/**
	 * Crea un objeto EnvioWs a partir de sus atributos.
	 * 
	 *  documento
	 *            DocumentoAperturas
	 *  usuario
	 *            the usuario
	 *  EnvioWs
	 *
	 * @param documento the documento
	 * @param usuario the usuario
	 * @return the envio ws
	 */
	public EnvioWs construirEnvioWs(DocumentoAperturas documento, String usuario) {
		EnvioWs envio = new EnvioWs();

		envio.setIdInterno(documento.getIdDocumento065().toString());
		envio.setUidPuestoSolicitante(UtilSeguridad.getInstance()
				.getUserCredentials() != null ? UtilSeguridad.getInstance()
				.getUserCredentials().getPosition() : usuario);
		envio.setExpediente(documento.getTramiteAperturas().getApertura()
				.getNumExpediente());
		envio.setDestinatario(this.construirDestinatarioWs(documento));

		return envio;
	}

	/**
	 * Crea un objeto EnvioWs a partir de sus atributos.
	 * 
	 *  documento
	 *            DocumentoAperturas
	 *  usuario
	 *            the usuario
	 *  EnvioWs
	 *
	 * @param documento the documento
	 * @param usuario the usuario
	 * @return the envio ws
	 */
	public EnvioWs construirEnvioWs(DocumentoOS2 documento, String usuario) {
		EnvioWs envio = new EnvioWs();

		envio.setIdInterno(documento.getIdDocumento094().toString());
		envio.setUidPuestoSolicitante(UtilSeguridad.getInstance()
				.getUserCredentials() != null ? UtilSeguridad.getInstance()
				.getUserCredentials().getPosition() : usuario);
		envio.setExpediente(documento.getTramiteOS2().getos2()
				.getNumExpediente());
		envio.setDestinatario(this.construirDestinatarioWs(documento));

		return envio;
	}

	/**
	 * Crea un objeto EnvioWs a partir de sus atributos.
	 * 
	 *  documento
	 *            DocumentoAperturas
	 *  usuario
	 *            the usuario
	 *  EnvioWs
	 *
	 * @param documento the documento
	 * @param usuario the usuario
	 * @return the envio ws
	 */
	public EnvioWs construirEnvioWs(DocumentoOS3 documento, String usuario) {
		EnvioWs envio = new EnvioWs();

		envio.setIdInterno(documento.getIdDocumento097().toString());
		envio.setUidPuestoSolicitante(UtilSeguridad.getInstance()
				.getUserCredentials() != null ? UtilSeguridad.getInstance()
				.getUserCredentials().getPosition() : usuario);
		envio.setExpediente(documento.getTramiteOS3().getOs3()
				.getNumExpediente());
		envio.setDestinatario(this.construirDestinatarioWs(documento));

		return envio;
	}

	/**
	 * Crea un objeto DestinatarioWs a partir de sus atributos.
	 * 
	 *  documento
	 *            DocumentoAperturas
	 *  DestinatarioWs
	 *
	 * @param documento the documento
	 * @return the destinatario ws
	 */
	public DestinatarioWs construirDestinatarioWs(DocumentoAperturas documento) {

		ObjectFactory of = new ObjectFactory();
		DestinatarioWs destinatario = new DestinatarioWs();

		ComunicacionApertura apertura = documento.getTramiteAperturas()
				.getApertura();
		DatosLocalizacion datosLocalizacion = apertura.getDatosNotificacion()
				.getDatosLocalizacion();

		if (!Utilities.getInstance().isEmpty(
				apertura.getNumdocrepresentante056())) {
			// Tiene representante
			// TODO no tenemos el nombre del representante
			destinatario.getInstitucionOrNombreApellidos().add(
					of.createNombreApellidos(apertura
							.getNumdocrepresentante056()));
		} else {
			// NO tiene representante
			destinatario.getInstitucionOrNombreApellidos().add(
					of.createInstitucion(apertura.getNomemp056()));
		}

		destinatario.setProvincia(datosLocalizacion.getProvincia()
				.getDescripcion());
		destinatario.setLocalidad(datosLocalizacion.getLocalidad()
				.getDescripcion());
		destinatario.setMunicipio(datosLocalizacion.getMunicipio()
				.getDescripcion());
		destinatario.setDireccion(datosLocalizacion.getDireccionCompleta());
		destinatario.setCodigoPostal(datosLocalizacion.getCodpostal067());

		return destinatario;
	}

	/**
	 * Crea un objeto DestinatarioWs a partir de sus atributos.
	 * 
	 *  documento
	 *            DocumentoAperturas
	 *  DestinatarioWs
	 *
	 * @param documento the documento
	 * @return the destinatario ws
	 */
	public DestinatarioWs construirDestinatarioWs(DocumentoOS2 documento) {

		ObjectFactory of = new ObjectFactory();
		DestinatarioWs destinatario = new DestinatarioWs();

		OS2 os2 = documento.getTramiteOS2().getos2();
		DatosLocalizacion datosLocalizacion = os2.getDatosNotificacion()
				.getDatosLocalizacion();

		if (!Utilities.getInstance().isEmpty(os2.getNumdocrepresentante060())) {
			// Tiene representante
			// TODO no tenemos el nombre del representante
			destinatario.getInstitucionOrNombreApellidos().add(
					of.createNombreApellidos(os2.getNumdocrepresentante060()));
		} else {
			// NO tiene representante
			destinatario.getInstitucionOrNombreApellidos().add(
					of.createInstitucion(os2.getNomemp060()));
		}

		destinatario.setProvincia(datosLocalizacion.getProvincia()
				.getDescripcion());
		destinatario.setLocalidad(datosLocalizacion.getLocalidad()
				.getDescripcion());
		destinatario.setMunicipio(datosLocalizacion.getMunicipio()
				.getDescripcion());
		destinatario.setDireccion(datosLocalizacion.getDireccionCompleta());
		destinatario.setCodigoPostal(datosLocalizacion.getCodpostal067());

		return destinatario;
	}

	/**
	 * Crea un objeto DestinatarioWs a partir de sus atributos.
	 * 
	 *  documento
	 *            DocumentoAperturas
	 *  DestinatarioWs
	 *
	 * @param documento the documento
	 * @return the destinatario ws
	 */
	public DestinatarioWs construirDestinatarioWs(DocumentoOS3 documento) {

		ObjectFactory of = new ObjectFactory();
		DestinatarioWs destinatario = new DestinatarioWs();

		OS3 os3 = documento.getTramiteOS3().getOs3();
		DatosLocalizacion datosLocalizacion = os3.getDatosNotificacion()
				.getDatosLocalizacion();

		if (!Utilities.getInstance().isEmpty(os3.getNumdocrepresentante061())) {
			// Tiene representante
			// TODO no tenemos el nombre del representante
			destinatario.getInstitucionOrNombreApellidos().add(
					of.createNombreApellidos(os3.getNumdocrepresentante061()));
		} else {
			// NO tiene representante
			destinatario.getInstitucionOrNombreApellidos().add(
					of.createInstitucion(os3.getNomemp061()));
		}

		destinatario.setProvincia(datosLocalizacion.getProvincia()
				.getDescripcion());
		destinatario.setLocalidad(datosLocalizacion.getLocalidad()
				.getDescripcion());
		destinatario.setMunicipio(datosLocalizacion.getMunicipio()
				.getDescripcion());
		destinatario.setDireccion(datosLocalizacion.getDireccionCompleta());
		destinatario.setCodigoPostal(datosLocalizacion.getCodpostal067());

		return destinatario;
	}

	/**
	 * Crea un objeto IdentTramitadorWs a partir de sus atributos.
	 * 
	 *  idEnvio
	 *            Integer
	 *  IdentTramitadorWs
	 *
	 * @param idEnvio the id envio
	 * @return the ident tramitador ws
	 */
	public IdentTramitadorWs construirIdentTramitadorWs(Integer idEnvio) {
		IdentTramitadorWs identTramitador = new IdentTramitadorWs();

		identTramitador.setId(idEnvio);
		identTramitador.setUidPuestoTramitador(UtilSeguridad.getInstance()
				.getUserCredentials().getPosition());

		return identTramitador;
	}

	/**
	 * Crea un objeto IdentTramitadorWs a partir de sus atributos.
	 * 
	 *  idEnvio
	 *            Integer
	 *  IdentTramitadorWs
	 *
	 * @param idEnvio the id envio
	 * @return the ident tramitador condicional ws
	 */
	public IdentTramitadorCondicionalWs construirIdentTramitadorCondicionalWs(
			Integer idEnvio) {
		IdentTramitadorCondicionalWs identTramitador = new IdentTramitadorCondicionalWs();

		identTramitador.setId(idEnvio);
		identTramitador.setUidPuestoTramitador(UtilSeguridad.getInstance()
				.getUserCredentials().getPosition());
		identTramitador.setTodas(true);

		return identTramitador;
	}

	/**
	 * Construir datos envio postal.
	 * 
	 *  remesa
	 *            RemesaOutWs
	 *  DatosEnvioPostal
	 *
	 * @param remesa the remesa
	 * @return the datos envio postal
	 */
	public DatosEnvioPostal construirDatosEnvioPostal(RemesaOutWs remesa) {

		DatosEnvioPostal datosEnvioPostal = new DatosEnvioPostal();
		datosEnvioPostal.setIdRemesa069(remesa.getIdremesa());
		datosEnvioPostal.setCodRemesa069(remesa.getCodigoRemesa());
		datosEnvioPostal.setIdColeccion069(remesa.getIdColeccion());
		datosEnvioPostal.setCodColeccion069(remesa.getCodigoColeccion());

		if (remesa.getEnvios() != null && !remesa.getEnvios().isEmpty()) {
			EnvioOutWs envio = remesa.getEnvios().get(0);
			datosEnvioPostal.setIdEnvio069(envio.getIdEnvio());
			datosEnvioPostal.setCodEnvio069(envio.getCodEnvio());
			datosEnvioPostal
					.setCodSituacionEnvio069(SituacionEntregaEnum.NO_SITUACION
							.getCodSituacionEntrega());
		}

		datosEnvioPostal.setFecnotificacion069(new Date());

		return datosEnvioPostal;
	}

}